/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rcs;

import com.ibm.hwmca.fw.rcs.CommManager;
import com.ibm.hwmca.fw.rcs.PathQueueListener;
import com.ibm.hwmca.fw.rcs.RcsCallbackSegment;
import com.ibm.hwmca.fw.rcs.RcsControl;
import com.ibm.hwmca.fw.rcs.link.LinkAlreadyActiveException;
import com.ibm.hwmca.fw.rcs.link.LinkFailedException;
import com.ibm.hwmca.fw.rcs.link.LinkNotActiveException;
import com.ibm.hwmca.fw.rcs.link.LinkNotConfiguredException;
import com.ibm.hwmca.fw.rcs.link.RcsLink;
import com.ibm.hwmca.fw.rcs.path.PathCancelReason;
import com.ibm.hwmca.fw.rcs.path.PathEvent;
import com.ibm.hwmca.fw.rcs.path.PathIdentifier;
import com.ibm.hwmca.fw.rcs.path.PathPriority;
import com.ibm.hwmca.fw.rcs.path.RcsPath;
import com.ibm.hwmca.fw.shutdown.ShutdownListener;
import com.ibm.hwmca.fw.shutdown.ShutdownManager;
import com.ibm.hwmca.fw.shutdown.ShutdownRequest;
import com.ibm.hwmca.fw.util.Trace;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PathManager
implements ShutdownListener {
    private static final String TRACE_MASKT = "XRCSMGRT";
    private static final String TRACE_MASKF = "XRCSMGRF";
    private static final String TRACE_MASKD = "XRCSMGRD";
    private static PathManager instance;
    protected Set activePaths;
    protected Set waitingPaths;
    protected Set readyPaths;
    private static final long TIMEOUT = 60000L;
    protected Map paths;
    private Object lock = new Object();
    protected RcsLink activeLink = null;
    protected boolean queueOnHold = false;
    private boolean shutdown = false;
    protected List listeners;

    private PathManager() {
        Trace.trace(TRACE_MASKT, "--> PathManager()");
        CommManager.getCommManager();
        Queue.highPriority = new LinkedList();
        Queue.lowPriority = new LinkedList();
        this.activePaths = new HashSet();
        this.readyPaths = new HashSet();
        this.waitingPaths = new HashSet();
        this.paths = new HashMap();
        this.listeners = new ArrayList();
        this.initRcsControl();
        RcsCallbackSegment.run();
        new Thread(){

            public void run() {
                this.setName("PathManager worker thread.");
                PathManager.this.managePaths();
            }
        }.start();
        ShutdownManager.getShutdownManager().addShutdownListener(this);
        Trace.trace(TRACE_MASKT, "<-- PathManager");
    }

    public static PathManager getPathManager() {
        if (instance == null) {
            instance = new PathManager();
        }
        Trace.trace(TRACE_MASKT, "<-> getPathManager() [" + instance + "]");
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void managePaths() {
        Trace.trace(TRACE_MASKT, "--> managePaths()");
        Object object = this.lock;
        synchronized (object) {
            while (!this.shutdown) {
                try {
                    RcsPath path;
                    PathIdentifier pathId;
                    Iterator i;
                    Trace.trace(TRACE_MASKD, "  ] managePaths() thread running");
                    if (!this.waitingPaths.isEmpty()) {
                        Trace.trace(TRACE_MASKD, "  ] paths are waiting for a link to open");
                        i = this.waitingPaths.iterator();
                        while (i.hasNext()) {
                            pathId = (PathIdentifier)i.next();
                            path = (RcsPath)this.paths.get(pathId);
                            if (this.activeLink != null && this.activeLink.isActive()) {
                                Trace.trace(TRACE_MASKD, "  ] attempting to utilize active link");
                                if (path.getSupportedLinkTypes().contains(this.activeLink.getClass())) {
                                    i.remove();
                                    this.activePaths.add(pathId);
                                    path.sendEvent(PathEvent.OPENED);
                                }
                            }
                            if (this.activeLink != null && this.activeLink.isActive()) continue;
                            Trace.trace(TRACE_MASKD, "  ] no active link");
                            this.activeLink = null;
                            List links = path.getSupportedLinkTypes();
                            boolean nothingWasConfigured = true;
                            if (links == null) continue;
                            Iterator li = links.iterator();
                            while (li.hasNext()) {
                                Class linkClass = (Class)li.next();
                                Trace.trace(TRACE_MASKD, "  ] attempting to use " + linkClass);
                                try {
                                    Method method = linkClass.getMethod("getInstance", null);
                                    RcsLink link = (RcsLink)method.invoke(null, null);
                                    method = linkClass.getMethod("isConfigured", null);
                                    boolean configured = (Boolean)method.invoke((Object)link, null);
                                    if (!configured) continue;
                                    nothingWasConfigured = false;
                                    method = linkClass.getMethod("activate", null);
                                    method.invoke((Object)link, null);
                                    this.activeLink = link;
                                    Trace.trace(TRACE_MASKD, "  ] " + linkClass + " was successfully activated");
                                    i.remove();
                                    this.activePaths.add(pathId);
                                    path.sendEvent(PathEvent.OPENED);
                                    break;
                                }
                                catch (InvocationTargetException invokeException) {
                                    Throwable e = invokeException.getCause();
                                    Trace.trace(TRACE_MASKD, "Exception: " + e);
                                    if (e == null || e instanceof LinkAlreadyActiveException || e instanceof LinkFailedException || e instanceof LinkNotConfiguredException) continue;
                                }
                                catch (Exception e) {
                                    Trace.trace(TRACE_MASKF, "Exception: " + e);
                                }
                            }
                            if (this.activeLink != null) continue;
                            this.cancelPath(pathId, PathCancelReason.LINK);
                            if (nothingWasConfigured) {
                                Trace.trace(TRACE_MASKD, "  ] no links were configured");
                                continue;
                            }
                            Trace.trace(TRACE_MASKD, "  ] all links failed to connect");
                        }
                    }
                    if (this.activeLink != null && this.activeLink.isActive()) {
                        Trace.trace(TRACE_MASKD, "  ] there is an active link");
                        i = Queue.highPriority.iterator();
                        while (i.hasNext()) {
                            Trace.trace(TRACE_MASKD, "  ] queued high priority paths");
                            pathId = (PathIdentifier)i.next();
                            path = (RcsPath)this.paths.get(pathId);
                            if (!path.getSupportedLinkTypes().contains(this.activeLink.getClass())) continue;
                            i.remove();
                            Trace.trace(TRACE_MASKD, "adding " + pathId + " to readyPaths");
                            this.readyPaths.add(pathId);
                            path.sendEvent(PathEvent.READY);
                        }
                        if (!Queue.lowPriority.isEmpty()) {
                            Trace.trace(TRACE_MASKD, "  ] queued low priority paths");
                            Trace.trace(TRACE_MASKD, "waitingPaths.size() = " + this.waitingPaths.size());
                            Trace.trace(TRACE_MASKD, "readyPaths.size() = " + this.readyPaths.size());
                            Trace.trace(TRACE_MASKD, "activePaths.size() = " + this.activePaths.size());
                            i = Queue.lowPriority.iterator();
                            while (this.waitingPaths.size() + this.readyPaths.size() + this.activePaths.size() < this.activeLink.getMaxOpenPaths() && i.hasNext()) {
                                pathId = (PathIdentifier)i.next();
                                path = (RcsPath)this.paths.get(pathId);
                                Trace.trace(TRACE_MASKD, "checking " + pathId + " to see if it can utilize this connection");
                                if (!path.getSupportedLinkTypes().contains(this.activeLink.getClass())) break;
                                i.remove();
                                Trace.trace(TRACE_MASKD, "adding " + pathId + " to readyPaths");
                                this.readyPaths.add(pathId);
                                path.sendEvent(PathEvent.READY);
                            }
                        }
                        if (this.activePaths.isEmpty() && this.readyPaths.isEmpty()) {
                            Trace.trace(TRACE_MASKD, "  ] nothing active, deactivating link");
                            this.activeLink.deactivate();
                            this.activeLink = null;
                        }
                    }
                    if (this.activeLink == null || !this.activeLink.isActive()) {
                        Trace.trace(TRACE_MASKD, "  ] there is no active link");
                        this.activeLink = null;
                        if (!this.activePaths.isEmpty()) {
                            Trace.trace(TRACE_MASKD, "  ] active paths is not empty (bad)");
                            i = this.activePaths.iterator();
                            while (i.hasNext()) {
                                pathId = (PathIdentifier)i.next();
                                this.cancelPath(pathId, PathCancelReason.LINK);
                            }
                        }
                        if (this.readyPaths.isEmpty() && this.waitingPaths.isEmpty()) {
                            PathIdentifier pathId2;
                            Trace.trace(TRACE_MASKD, "  ] waiting paths is empty");
                            if (!Queue.highPriority.isEmpty()) {
                                pathId2 = (PathIdentifier)Queue.highPriority.remove(0);
                                Trace.trace(TRACE_MASKD, "adding " + pathId2 + " to readyPaths");
                                this.readyPaths.add(pathId2);
                                ((RcsPath)this.paths.get(pathId2)).sendEvent(PathEvent.READY);
                            } else if (!Queue.lowPriority.isEmpty()) {
                                pathId2 = (PathIdentifier)Queue.lowPriority.remove(0);
                                Trace.trace(TRACE_MASKD, "adding " + pathId2 + " to readyPaths");
                                this.readyPaths.add(pathId2);
                                ((RcsPath)this.paths.get(pathId2)).sendEvent(PathEvent.READY);
                            }
                        }
                    }
                    try {
                        Trace.trace(TRACE_MASKT, "  ] managePaths() thread sleeping");
                        this.lock.wait(60000L);
                    }
                    catch (Exception e) {
                        Trace.trace(TRACE_MASKF, "Exception: " + e);
                    }
                }
                catch (Exception e) {
                    Trace.trace(TRACE_MASKF, "EXCEPTION CAUGHT: " + e);
                }
            }
            ArrayList allPaths = new ArrayList();
            allPaths.addAll(Queue.highPriority);
            allPaths.addAll(Queue.lowPriority);
            allPaths.addAll(this.readyPaths);
            allPaths.addAll(this.waitingPaths);
            allPaths.addAll(this.activePaths);
            Iterator i = allPaths.iterator();
            while (i.hasNext()) {
                PathIdentifier pathId = (PathIdentifier)i.next();
                this.cancelPath(pathId, PathCancelReason.SHUTDOWN);
            }
            this.stopRcsControl();
        }
        Trace.trace(TRACE_MASKT, "<-- managePaths()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getActivePaths() {
        Trace.trace(TRACE_MASKT, "--> getActivePaths()");
        ArrayList paths = new ArrayList();
        Object object = this.lock;
        synchronized (object) {
            paths.addAll(this.activePaths);
        }
        Trace.trace(TRACE_MASKT, "<-- getActivePaths() [" + paths + "]");
        return paths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPath(RcsPath path) throws NullPointerException {
        Trace.trace(TRACE_MASKT, "--> addPath( " + path + " )");
        if (path == null) {
            throw new NullPointerException();
        }
        Object object = this.lock;
        synchronized (object) {
            PathIdentifier pathId = path.getPathIdentifier();
            int position = 0;
            this.paths.put(pathId, path);
            if (path.getPriority() == PathPriority.LOW) {
                Queue.lowPriority.add(pathId);
                position = Queue.lowPriority.indexOf(pathId);
            } else if (path.getPriority() == PathPriority.HIGH) {
                Queue.highPriority.add(pathId);
            }
            Iterator listenIt = this.listeners.iterator();
            while (listenIt.hasNext()) {
                ((PathQueueListener)listenIt.next()).addedToWaiting(pathId, position);
            }
            Trace.trace(TRACE_MASKD, "  ] notify worker thread...");
            this.lock.notify();
        }
        Trace.trace(TRACE_MASKT, "<-- addPath()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelPath(PathIdentifier pathId, PathCancelReason reason) throws IllegalArgumentException {
        Trace.trace(TRACE_MASKT, "--> cancelPath( " + pathId + ", " + reason + " )");
        Object object = this.lock;
        synchronized (object) {
            try {
                if (!this.paths.keySet().contains(pathId)) {
                    throw new IllegalArgumentException();
                }
                RcsPath path = (RcsPath)this.paths.get(pathId);
                path.sendEvent(PathEvent.CANCELLED, reason);
                this.closePath(pathId);
                this.lock.notify();
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, "Exception: " + e);
            }
        }
        Trace.trace(TRACE_MASKT, "<-- cancelPath()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openPath(PathIdentifier pathId) throws IllegalArgumentException {
        Trace.trace(TRACE_MASKT, "--> openPath( " + pathId + " )");
        Object object = this.lock;
        synchronized (object) {
            try {
                if (!this.paths.keySet().contains(pathId)) {
                    throw new IllegalArgumentException();
                }
                RcsPath path = (RcsPath)this.paths.get(pathId);
                if (!this.readyPaths.contains(pathId)) {
                    throw new IllegalArgumentException();
                }
                this.readyPaths.remove(pathId);
                this.waitingPaths.add(pathId);
                Iterator listenIt = this.listeners.iterator();
                while (listenIt.hasNext()) {
                    ((PathQueueListener)listenIt.next()).moveFromWaitingToActive(pathId);
                }
                this.lock.notify();
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, "Exception: " + e);
            }
        }
        Trace.trace(TRACE_MASKT, "<-- openPath()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closePath(PathIdentifier pathId) throws IllegalArgumentException {
        Trace.trace(TRACE_MASKT, "--> closePath( " + pathId + " )");
        Object object = this.lock;
        synchronized (object) {
            try {
                boolean wasActive = false;
                if (!this.paths.keySet().contains(pathId)) {
                    throw new IllegalArgumentException();
                }
                if (this.activePaths.remove(pathId)) {
                    wasActive = true;
                }
                if (this.waitingPaths.remove(pathId)) {
                    wasActive = true;
                }
                this.readyPaths.remove(pathId);
                Queue.highPriority.remove(pathId);
                Queue.lowPriority.remove(pathId);
                this.paths.remove(pathId);
                Iterator listenIt = this.listeners.iterator();
                while (listenIt.hasNext()) {
                    if (wasActive) {
                        ((PathQueueListener)listenIt.next()).removedFromActive(pathId);
                        continue;
                    }
                    ((PathQueueListener)listenIt.next()).removedFromWaiting(pathId);
                }
                this.lock.notify();
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, "Exception: " + e);
            }
        }
        Trace.trace(TRACE_MASKT, "<-- closePath()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getQueuedPaths() {
        Trace.trace(TRACE_MASKT, "--> getQueuedPaths()");
        ArrayList queue = new ArrayList();
        Object object = this.lock;
        synchronized (object) {
            queue.addAll(this.waitingPaths);
            queue.addAll(this.readyPaths);
            queue.addAll(Queue.highPriority);
            queue.addAll(Queue.lowPriority);
        }
        Trace.trace(TRACE_MASKT, "<-- getQueuedPaths() [" + queue + "]");
        return queue;
    }

    public void setPriority(PathIdentifier pathId, PathPriority priority) throws IllegalArgumentException {
        Trace.trace(TRACE_MASKT, "--> setPriority( " + pathId + ", " + priority + " )");
        Trace.trace(TRACE_MASKT, "<-- setPriority()");
    }

    public void setPathNext(PathIdentifier pathId) throws IllegalArgumentException {
        Trace.trace(TRACE_MASKT, "--> setPathNext( " + pathId + " )");
    }

    public boolean failLink() {
        if (this.activeLink == null) {
            Trace.trace(TRACE_MASKT, "<-> failLink() [false]");
            return false;
        }
        boolean fail = this.activeLink.fail();
        Trace.trace(TRACE_MASKT, "<-> failLink() [" + fail + "]");
        return fail;
    }

    public InetAddress getLinkAddress() throws LinkNotActiveException {
        if (this.activeLink == null) {
            throw new LinkNotActiveException();
        }
        InetAddress ip = this.activeLink.getAddress();
        Trace.trace(TRACE_MASKT, "<-> getLinkAddress() [" + ip + "]");
        return ip;
    }

    public boolean isHighPerformanceLink() throws LinkNotActiveException {
        if (this.activeLink == null) {
            throw new LinkNotActiveException();
        }
        boolean hpl = this.activeLink.isHighPerformanceLink();
        Trace.trace(TRACE_MASKT, "<-> isHighPerformanceLink() [" + hpl + "]");
        return hpl;
    }

    private void initRcsControl() {
        RcsControl.init();
    }

    private void stopRcsControl() {
        RcsControl.quit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownStarting(ShutdownRequest request, long delay) {
        Trace.trace(TRACE_MASKT, "--> shutdownStarting( " + request + ", " + delay + " )");
        Object object = this.lock;
        synchronized (object) {
            this.shutdown = true;
            this.lock.notify();
        }
        Trace.trace(TRACE_MASKT, "<-- shutdownStarting()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List[] addPathQueueListener(PathQueueListener listener) throws NullPointerException {
        Trace.trace(TRACE_MASKT, "--> addPathQueueListener(" + listener + ")");
        if (listener == null) {
            throw new NullPointerException("listener is null");
        }
        List[] queues = null;
        Object object = this.lock;
        synchronized (object) {
            this.listeners.add(listener);
            queues = new List[]{this.getActivePaths(), this.getQueuedPaths()};
        }
        Trace.trace(TRACE_MASKT, "<-- addPathQueueListener() [" + queues + "]");
        return queues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePathQueueListener(PathQueueListener listener) {
        Trace.trace(TRACE_MASKT, "--> removePathQueueListener(" + listener + ")");
        Object object = this.lock;
        synchronized (object) {
            if (listener != null) {
                this.listeners.remove(listener);
            }
        }
        Trace.trace(TRACE_MASKT, "<-- removePathQueueListener()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setQueueOnHold(boolean value) {
        Trace.trace(TRACE_MASKT, "--> setQueueOnHold(" + value + ")");
        Object object = this.lock;
        synchronized (object) {
            if (this.queueOnHold != value) {
                this.queueOnHold = value;
                Iterator listenIt = this.listeners.iterator();
                while (listenIt.hasNext()) {
                    ((PathQueueListener)listenIt.next()).queueStateChanged(value);
                }
            }
        }
        Trace.trace(TRACE_MASKT, "<-- setQueueOnHold()");
    }

    public boolean isQueueOnHold() {
        Trace.trace(TRACE_MASKT, "<-> isQueueOnHold() [" + this.queueOnHold + "]");
        return this.queueOnHold;
    }

    protected static class Queue {
        public static List highPriority;
        public static List lowPriority;

        protected Queue() {
        }
    }

    public static class Init
    implements Runnable {
        public void run() {
            Trace.trace(PathManager.TRACE_MASKT, "--> Init.run()");
            PathManager.getPathManager();
            Trace.trace(PathManager.TRACE_MASKT, "<-- Init.run()");
        }
    }
}

